<?php
session_start();
include 'database.php';

if (!isset($_SESSION['username'])) {
    header('Location: ../adminx');
    exit;
}

$sql = "SELECT * FROM users ORDER BY createDate DESC";
$result = $conn->query($sql);

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home - Key Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <link href="style/common.css" rel="stylesheet">
    <link href="dialog/ud-dialog.css" rel="stylesheet">

    <style>
        select[disabled] {
            background-color: #f9f9f9;
            color: #6c757d;
            cursor: not-allowed;
            pointer-events: none;
        }
        .type {
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            color: #343a40;
            border-radius: 7px;
            padding: 10px;
            font-size: 1rem;
            width: 100%;
            box-sizing: border-box;
        }

        .type:focus {
            outline: none;
            border-color: #007bff;
        }

        .type option {
            background-color: #ffffff;
            color: #343a40;
            font-size: 14px;
        }
        .status {
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            color: #343a40;
            border-radius: 7px;
            padding: 10px;
            font-size: 1rem;
            width: 100%;
            box-sizing: border-box;
        }

        .status:focus {
            outline: none;
            border-color: #007bff;
        }

        .status option {
            background-color: #ffffff;
            color: #343a40;
            font-size: 14px;
        }


        .hbutton {
            transform: translateY(-5px);
        }

        /* Table Styles */
        .d-table {
            width: 95%;
            margin: 25px auto;
            border: 1px solid #ddd;
            border-radius: 10px;
            overflow: hidden;
            table-layout: auto;
            background-color: #ffffff;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .user-table-container .rtable {
            width: 100%;
            border-collapse: collapse;
        }

        .user-table-container .rdh, .user-table-container .rd {
            padding: 8px;
            font-size: 60%;
            text-align: center;
        }

        .user-table-container .rdh {
            background: linear-gradient(90deg, #007bff, #66b2ff);
            color: #ffffff;
            text-transform: uppercase;
        }

        .user-table-container .r {
            transition: background-color 0.3s ease;
        }

        .user-table-container .r:hover {
            background-color: #E0FFFF;
            animation: joomInOut 0.4s ease-in-out;
        }

        /* Even Rows */
        tr.r:nth-child(even) {
            background-color: #f2f2f2;
        }

        /* Odd Rows */
        tr.r:nth-child(odd) {
            background-color: #ffffff;
        }

@keyframes joomInOut {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.03);
            }
            100% {
                transform: scale(1);
            }
        }

@media (max-width: 768px) {
            .user-table-container .d-table {
                width: 740px;
            }
            .user-table-container .rdh, .user-table-container .rd {
                font-size: 75%;
            }
        }

@media (max-width: 480px) {
            .user-table-container .d-table {
                width: 95%;
            }
            .user-table-container .rdh, .user-table-container .rd {
                font-size: 65%;
            }
        }

    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-light">
        <div class="container-fluid">
            <a class="navbar-brand">সাইন থেকে এন আই ডি এডমিন প্যানেল</a>
        </div>
        <div class="ic">
            <div class="button-container">
                <button class="button hbutton" onclick="window.location.href = 'dashboard.php'">
                    <img src="img/home.png">
                </button>
                <button class="button" onclick="window.location.href = 'search.php'">
                    <img src="img/search.png">
                </button>
                <button class="button" onclick="window.location.href = 'addkey.php'">
                    <img src="img/ckey.png">
                </button>
                <button class="button" onclick="IP()">
                    <img src="img/block.png">
                </button>
                <button class="button lbutton" onclick="window.location.href = 'logout.php'">
                    <img src="img/logout.png">
                </button>
            </div>
        </div>
    </nav>


    <div class="user-table-container">
        <div class="table-responsive d-table">
            <table class="rtable">
                <thead>
                    <tr>
                        <th class='rdh'>ID</th>
                        <th class='rdh'>Username</th>
                        <th class='rdh'>API Key</th>
                        <th class="rdh">Type</th>
                        <th class='rdh'>Limit</th>
                        <th class='rdh'>Expire Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $total_rows = $result->num_rows;
                    $row_number = $total_rows;

                    while ($row = $result->fetch_assoc()) {
                        $lmt = $row['limit'] == 99999999 ? 'UNLIMITED' : $row['limit'];
                        $bal = $row['balance'] == 99999999 ? 'UNLIMITED' : $row['balance'];

                        echo "<tr class='r'
                                  data-username='" . htmlspecialchars($row['username']) . "'
                                  data-apiKey='" . htmlspecialchars($row['apiKey']) . "'
                                  data-type='" . htmlspecialchars($row['type']) . "'
                                  data-Status='" . htmlspecialchars($row['status']) . "'
                                  data-createDate='" . htmlspecialchars($row['createDate']) . "'
                                  data-expiryDate='" . htmlspecialchars($row['expiryDate']) . "'
                                  data-limit='" . htmlspecialchars($lmt) . "'
                                  data-balance='" . htmlspecialchars($bal) . "'
                                  data-used='" . htmlspecialchars($row['used']) . "'>
                                <td class='rd'>" . $row_number . "</td>
                                <td class='rd'>" . htmlspecialchars($row['username']) . "</td>
                                <td class='rd'>" . htmlspecialchars($row['apiKey']) . "</td>
                                <td class='rd'>" . htmlspecialchars(strtoupper($row['type'])) . "</td>
                                <td class='rd'>" . htmlspecialchars($lmt) . "</td>
                                <td class='rd'>" . htmlspecialchars($row['expiryDate']) . "</td>
                             </tr>";
                        $row_number--;
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal-overlay" id="userDetailsModal">
        <div class="modal-content">
            <span class="close-button" id="closeModal">&times;</span>
            <div class="modal-header">
                User Details
            </div>
            <table class='udt'>
                <tbody>
                    <tr>
                        <th class='udh'>Username</th>
                        <td class='ud'><input type="text" id="username" readonly></td>
                        <td class="icon-cell" onclick="editUsername()"><i class="bi bi-pencil-square"></i></td>
                    </tr>
                    <tr>
                        <th class='udh'>API Key</th>
                        <td class='ud'><input type="text" id="apikey" readonly></td>
                        <td class="icon-cell" onclick="key()"><i class="bi bi-key"></i></td>
                    </tr>
                    <tr>
                        <th class="udh">Key type</th>
                        <td class="ud">
                            <select class="type" id="type" name="type" disabled>
                                <option id="type-option"></option>
                            </select>
                        </td>
                        <td class="icon-cell" onclick="editKeyType()"><i class="bi bi-pencil-square"></i></td>
                    </tr>
                    <tr>
                        <th class="udh">Key status</th>
                        <td class="ud">
                            <select class="status" id="status" name="status" disabled>
                                <option id="status-option"></option>
                            </select>
                        </td>
                        <td class="icon-cell" onclick="editKeyStatus()"><i class="bi bi-pencil-square"></i></td>
                    </tr>
                    <tr>
                        <th class='udh'>Create Date</th>
                        <td class='ud'><input type="text" id="credate" readonly></td>
                        <td class="icon-cell" onclick="creDate()"><i class="bi bi-calendar-event"></i></td>
                    </tr>
                    <tr>
                        <th class='udh'>Expire Date</th>
                        <td class='ud'><input type="text" id="expdate" readonly></td>
                        <td class="icon-cell" onclick="editExpDate()"><i class="bi bi-pencil-square"></i></td>
                    </tr>
                    <tr>
                        <th class='udh'>Limit</th>
                        <td class='ud'><input type="text" id="limit" readonly></td>
                        <td class="icon-cell" onclick="editLimit()"><i class="bi bi-pencil-square"></i></td>
                    </tr>
                    <tr>
                        <th class='udh'>Balance</th>
                        <td class='ud'><input type="text" id="balance" readonly></td>
                        <td class="icon-cell" onclick="balance()"><i class="bi bi-currency-dollar"></i></td>
                    </tr>
                    <tr>
                        <th class='udh'>Total Use</th>
                        <td class='ud'><input type="text" id="used" readonly></td>
                        <td class="icon-cell" onclick="used()"><i class="bi bi-bar-chart"></i></td>
                    </tr>
                </tbody>
            </table>
            <div style="display: flex; justify-content: space-between; margin-top: 15px;">
                <button class="btn-delete" id="dltKeyBtn">DELETE</button>
                <button class="btn-update" id="updtKeyBtn">UPDATE</button>
            </div>
        </div>
    </div>

    <script src="js/model.js"></script>
    <script src="js/IP.js"></script>

    <script>
        function balance() {
            swal("Attention!", "You don't need to edit the balance. To increase the balance, simply edit the limit. The balance will update automatically.", "info");
        }


        const modal = document.getElementById('userDetailsModal');
        const closeModal = document.getElementById('closeModal');
        const rows = document.querySelectorAll(".user-table-container .rtable tbody tr");

        const select = document.getElementById('type');
        const select2 = document.getElementById('status');

        rows.forEach(row => {
            row.addEventListener("click", () => {
                document.getElementById('username').value = row.dataset.username;
                document.getElementById('apikey').value = row.dataset.apikey;
                document.getElementById('credate').value = row.dataset.createdate;
                document.getElementById('expdate').value = row.dataset.expirydate;
                document.getElementById('limit').value = row.dataset.limit;
                document.getElementById('balance').value = row.dataset.balance;
                document.getElementById('used').value = row.dataset.used;

                const typeValue = row.dataset.type;
                const statusValue = row.dataset.status;

                select.innerHTML = '';
                select2.innerHTML = '';

                const currentOption = document.createElement('option');
                currentOption.value = typeValue;
                currentOption.textContent = typeValue.toUpperCase();
                currentOption.selected = true;
                select.appendChild(currentOption);

                const currentOption2 = document.createElement('option');
                currentOption2.value = statusValue;
                currentOption2.textContent = statusValue.toUpperCase();
                currentOption2.selected = true;
                select2.appendChild(currentOption2);

                modal.classList.add('active');
            });
        });

        closeModal.addEventListener('click', () => {
            modal.classList.remove('active');
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>