function IP() {
    swal({
        title: "Enter IP Address",
        text: "Enter a valid IP address to block or unblock.",
        content: {
            element: "input",
            attributes: {
                placeholder: "Enter IP Address",
                type: "text",
            },
        },
        buttons: {
            UNBLOCK: "UNBLOCK",
            BLOCKIP: "BLOCKIP",
        },
    })
    .then((value) => {
        const ip = document.querySelector(".swal-content__input").value.trim();

        if (!isValidIP(ip)) {
            swal("Invalid IP Address!", "Please enter a valid IP address.", {
                icon: "error",
            });
            return;
        }

        if (value === "UNBLOCK") {
            const action = "unblockIp";
            request(ip, action)
                .then((resp) => {
                    if (resp === "unblock") {
                        swal(`The IP (${ip}) has been unblocked.`, {
                            icon: "success",
                        });
                    } else {
                        swal("Failed to unblock the IP. Please try again.", {
                            icon: "error",
                        });
                    }
                })
                .catch((error) => {
                    console.error("Error:", error);
                    swal("An error occurred while unblocking the IP.", {
                        icon: "error",
                    });
                });
        } else if (value === "BLOCKIP") {
            const action = "blockIp";
            request(ip, action)
                .then((resp) => {
                    if (resp === "block") {
                        swal(`The IP (${ip}) has been blocked.`, {
                            icon: "success",
                        });
                    } else {
                        swal("Failed to block the IP. Please try again.", {
                            icon: "error",
                        });
                    }
                })
                .catch((error) => {
                    console.error("Error:", error);
                    swal("An error occurred while blocking the IP.", {
                        icon: "error",
                    });
                });
        } else {
            swal("No action selected. Please try again.", {
                icon: "warning",
            });
        }
    })
    .catch((error) => {
        console.error("Error:", error);
        swal("An error occurred while processing your request.", {
            icon: "error",
        });
    });
}

function request(ip, act) {
    return fetch(`ip.php?ip=${ip}&action=${act}`, {
        method: "GET",
    })
    .then((response) => response.json())
    .then((data) => {
        if (data.block) {
            return "block";
        } else if (data.unblock) {
            return "unblock";
        } else {
            return "error";
        }
    })
    .catch((error) => {
        console.error("Request error:", error);
        throw new Error("Network error occurred.");
    });
}

function isValidIP(ip) {
    const ipv4Regex = /^(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)$/;

    const ipv6Regex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)\.){3,3}(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)\.){3,3}(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?))$/;

    return ipv4Regex.test(ip) || ipv6Regex.test(ip);
}