<?php
/* --- Hidden PHP Backend (unchanged) --- */
header('X-Content-Type-Options: nosniff');
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Dhaka');
require_once __DIR__ . '/database.php'; // $conn

function fetch_key_row(mysqli $conn, string $key){
  $sql="SELECT apiKey,expiryDate,status,balance,used FROM users WHERE apiKey=? LIMIT 1";
  if(!$stmt=$conn->prepare($sql)) return [null,"DB prepare failed"];
  $stmt->bind_param("s",$key); $stmt->execute(); $res=$stmt->get_result();
  if($res->num_rows!==1){ $stmt->close(); return [null,"not_found"]; }
  $row=$res->fetch_assoc(); $stmt->close(); return [$row,null];
}
function build_payload(array $r){
  $now=new DateTimeImmutable('now'); $exp=new DateTimeImmutable($r['expiryDate']??'1970-01-01 00:00:00');
  $bal=(int)$r['balance']; $used=(int)$r['used']; $unl=($bal===99999999);
  $st=strtolower((string)$r['status']);
  if($exp<$now) $s='expired'; elseif($st!=='on') $s='deactivated'; else $s='active';
  return [
    'key'=>$r['apiKey'],'status'=>$s,'active'=>($s==='active'),
    'expiry'=>$exp->format('Y-m-d H:i:s'),'used'=>$used,
    'remaining'=>$unl?'unlimited':max(0,$bal),
    'total'=>$unl?'unlimited':max(0,$bal+$used),
    'time'=>$now->format('Y-m-d H:i:s')
  ];
}
$inputKey=trim((string)($_POST['key']??''));
?>
<!doctype html>
<html lang="bn">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>🔑 API KEY লিমিট চেকার</title>
<style>
/* ===== Light Theme (your original look) ===== */
:root{
  --bg:#f5f7fb; --card:#ffffff; --p:#7c3aed; --p2:#c026d3;
  --ok:#10b981; --bad:#e11d48; --muted:#6b7280; --ring:rgba(124,58,237,.18);
}
*{box-sizing:border-box}
body{margin:0;font-family:system-ui,-apple-system,Segoe UI,Roboto,Inter,Arial;background:var(--bg);color:#111827}

/* ===== Dragon layer (image + animated fire) ===== */
.dragon-stage{position:fixed; inset:0; pointer-events:none; z-index:0; overflow:hidden;}
.dragon-wrap{
  position:absolute; 
  /* ক্যানভাসের যে জায়গায় ড্রাগন চান, দরকার হলে এই 2টা ভ্যালু টিউন করবেন */
  left: 68vw;   /* horiz position */
  top:  26vh;   /* vert position  */
  width: min(30vw, 380px);
  transform: translate(-50%,-50%); /* anchor center */
  filter: drop-shadow(0 12px 24px rgba(0,0,0,.18));
}
.dragon-wrap img{
  width:100%; height:auto; display:block;
  /* চাইলে উল্টো করে বসাতে scaleX(-1) দিন */
  /* transform: scaleX(-1); */
}

/* Fire emitter — ড্রাগনের মুখের ঠিক সামনে অফসেট */
.fire-emitter{
  position:absolute;
  /* ইমেজের ভিতরে mouth offset — ছবির মুখ যেদিকে আছে সেই অনুযায়ী টিউন করা যাবে */
  left: 14%;   /* ছবির বাম থেকে mouth approx */
  top:  48%;   /* ছবির উপর থেকে mouth approx */
  transform: translate(-50%,-50%) rotate(-12deg);
  width: 12px; height: 12px;
}

/* আগুনের কণা (multiple spans) */
.fire-emitter span{
  position:absolute; left:0; top:0; width:12px; height:12px; border-radius:50%;
  background:
    radial-gradient(closest-side, rgba(255,214,102,1) 0%, rgba(255,77,0,0.95) 60%, rgba(255,77,0,0) 70%),
    radial-gradient(closest-side, rgba(255,255,255,.9) 0%, rgba(255,214,102,.0) 70%);
  mix-blend-mode: multiply;
  filter: blur(.2px) drop-shadow(0 0 8px rgba(255,130,0,.65));
  animation: spit 1.3s linear infinite, flicker .15s infinite;
  opacity:.95;
}

/* পার্টিকলগুলোর বিভিন্ন ডিলে/আকার/দিক */
.fire-emitter span:nth-child(3n+1){ animation-duration:1.1s; transform: rotate(-6deg) }
.fire-emitter span:nth-child(3n+2){ animation-duration:1.35s; transform: rotate(3deg) }
.fire-emitter span:nth-child(5n){   animation-duration:1.6s;  filter:blur(.4px) drop-shadow(0 0 12px rgba(255,160,0,.8)) }
.fire-emitter span{ --dx: 280px; --dy: -20px; --scale: 1.8; }
.fire-emitter span:nth-child(2){ --dy: -6px;  --scale:1.5 }
.fire-emitter span:nth-child(3){ --dy: 10px;  --scale:1.6 }
.fire-emitter span:nth-child(4){ --dy: -16px; --scale:2.0 }
.fire-emitter span:nth-child(5){ --dy:  4px;  --scale:1.7 }
.fire-emitter span:nth-child(6){ --dy: -10px; --scale:1.9 }
.fire-emitter span:nth-child(7){ --dy:  14px; --scale:2.2 }
.fire-emitter span:nth-child(8){ --dy: -8px;  --scale:1.6 }
.fire-emitter span:nth-child(9){ --dy:  0px;  --scale:2.1 }
.fire-emitter span:nth-child(10){--dy:  18px; --scale:2.4 }

/* আগুন বের হওয়া ট্র্যাজেক্টরি */
@keyframes spit{
  0%   { transform: translate(0,0) scale(.6) rotate(0deg); opacity:.95 }
  70%  { transform: translate(var(--dx), var(--dy)) scale(var(--scale)) rotate(2deg); opacity:.75 }
  100% { transform: translate(calc(var(--dx) + 60px), calc(var(--dy) - 8px)) scale(calc(var(--scale)*1.1)) rotate(4deg); opacity:0 }
}
/* হালকা ফ্লিকার */
@keyframes flicker{
  0%,100% { filter: blur(.2px) drop-shadow(0 0 8px rgba(255,130,0,.60)) }
  50%     { filter: blur(.3px) drop-shadow(0 0 12px rgba(255,160,0,.85)) }
}

/* ===== Card/UI ===== */
.wrap{min-height:100dvh;display:grid;place-items:center;padding:16px;position:relative;z-index:1}
.card{width:min(720px,94vw);background:var(--card);border-radius:18px;border:1px solid #eef2ff;
      box-shadow:0 14px 40px rgba(17,24,39,.06);overflow:hidden}
.head{background:linear-gradient(90deg,var(--p),var(--p2));color:#fff;text-align:center;padding:14px;font-weight:800;font-size:18px}
.body{padding:18px}
label{display:block;margin:0 0 6px 2px;font-size:14px}
.row{display:flex;gap:8px;flex-wrap:wrap}
input[type=text]{flex:1 1 260px;padding:14px;border-radius:12px;border:1px solid #e5e7eb;font-size:16px;background:#fafafa;outline:none}
input[type=text]:focus{border-color:var(--p2);box-shadow:0 0 0 5px var(--ring)}
button.btn{padding:14px 18px;border:none;border-radius:12px;font-weight:800;cursor:pointer;color:#fff;background:linear-gradient(90deg,var(--p),var(--p2));width:100%}
@media(min-width:420px){button.btn{width:auto}}
.grid{display:grid;grid-template-columns:1fr;gap:12px;margin-top:14px}
@media(min-width:560px){.grid{grid-template-columns:repeat(2,1fr)}}
.tile{background:#fcfdff;border:1px solid #eef2ff;padding:14px;border-radius:14px}
.t-k{font-size:12px;color:var(--muted);margin-bottom:6px}
.t-v{font-size:20px;font-weight:800}
.ok{color:var(--ok)} .bad{color:var(--bad)}
.alert{margin-top:12px;padding:12px;border-radius:12px;border:1px solid #fee2e2;background:#fef2f2;color:#991b1b}

.footer{display:flex;justify-content:center;align-items:center;padding:14px;border-top:1px solid #f1f5f9;background:#fff}
.wa{display:inline-flex;align-items:center;gap:8px;padding:12px 20px;border-radius:999px;text-decoration:none;background:#25D366;color:#06210f;
    font-weight:900;box-shadow:0 6px 18px rgba(37,211,102,.25);transition:transform .2s ease; user-select:none}
.wa svg{width:18px;height:18px;fill:currentColor}
.wa:hover{transform:translateY(-1px)}
</style>
</head>
<body>

<!-- Dragon image + live fire -->
<div class="dragon-stage" aria-hidden="true">
  <div class="dragon-wrap">
    <img src="https://static.vecteezy.com/system/resources/thumbnails/022/661/080/small/western-dragon-stock-illustration-free-png.png"
         alt="Dragon background" loading="lazy">
    <!-- fire emitter (10 particles, looping) -->
    <div class="fire-emitter">
      <span></span><span></span><span></span><span></span><span></span>
      <span></span><span></span><span></span><span></span><span></span>
    </div>
  </div>
</div>

<div class="wrap">
  <div class="card">
    <div class="head">🔑 API KEY লিমিট চেকার</div>
    <div class="body">
      <form method="post" autocomplete="off">
        <label for="key">আপনার API Key লিখুন</label>
        <div class="row">
          <input id="key" name="key" type="text" placeholder="উদাহরণ: DEMO_KEY" value="<?=htmlspecialchars($inputKey)?>">
          <button class="btn" type="submit">✓ যাচাই করুন</button>
        </div>
      </form>

<?php
if($inputKey!==''){
  [$row,$err]=fetch_key_row($conn,$inputKey);
  if($err==='not_found'){
    echo '<div class="alert">❌ Key পাওয়া যায়নি।</div>';
  } elseif($err){
    echo '<div class="alert">⚠️ ডাটাবেস সমস্যা!</div>';
  } else {
    $d=build_payload($row);
    $badge=$d['active']?'<span class="ok">ACTIVE</span>':($d['status']==='expired'?'<span class="bad">EXPIRED</span>':'<span class="bad">DEACTIVATED</span>');
    echo '<div class="grid">
      <div class="tile"><div class="t-k">স্ট্যাটাস</div><div class="t-v">'.$badge.'</div></div>
      <div class="tile"><div class="t-k">মেয়াদ</div><div class="t-v">'.htmlspecialchars($d['expiry']).'</div></div>
      <div class="tile"><div class="t-k">মোট লিমিট</div><div class="t-v">'.htmlspecialchars($d['total']).'</div></div>
      <div class="tile"><div class="t-k">ব্যবহৃত</div><div class="t-v">'.htmlspecialchars($d['used']).'</div></div>
      <div class="tile"><div class="t-k">বাকি (টোকেন)</div><div class="t-v">'.htmlspecialchars($d['remaining']).'</div></div>
      <div class="tile"><div class="t-k">সার্ভার সময়</div><div class="t-v">'.htmlspecialchars($d['time']).'</div></div>
    </div>';
  }
}
?>
    </div>

    <!-- WhatsApp (number hidden visually, multi-fallback opener) -->
    <div class="footer">
      <a id="waBtn" class="wa" href="#" role="button" aria-label="Open WhatsApp">
        <svg viewBox="0 0 32 32" aria-hidden="true"><path d="M19.11 17.57c-.28-.14-1.66-.82-1.92-.91-.26-.1-.45-.14-.64.14-.19.28-.73.91-.9 1.1-.17.19-.33.21-.6.07-.28-.14-1.18-.43-2.24-1.37-.83-.74-1.39-1.66-1.55-1.94-.16-.28-.02-.43.12-.57.12-.12.28-.33.42-.49.14-.16.19-.28.28-.47.09-.19.05-.35-.02-.49-.07-.14-.64-1.54-.88-2.1-.23-.56-.47-.48-.64-.49-.17-.01-.35-.01-.54-.01-.19 0-.49.07-.74.35-.26.28-1 1-1 2.44s1.02 2.83 1.16 3.03c.14.19 2 3.05 4.86 4.28.68.29 1.21.46 1.62.59.68.22 1.29.19 1.77.12.54-.08 1.66-.68 1.89-1.34.23-.66.23-1.22.16-1.34-.07-.12-.26-.19-.54-.33zM16.02 4.06c-6.6 0-11.95 5.35-11.95 11.95 0 2.11.55 4.17 1.6 5.98L4 28l6.18-1.62c1.74.95 3.69 1.45 5.84 1.45 6.6 0 11.95-5.35 11.95-11.95S22.62 4.06 16.02 4.06zm0 21.73c-1.91 0-3.67-.56-5.15-1.52l-.37-.23-3.66.96.98-3.56-.24-.37c-.98-1.52-1.56-3.31-1.56-5.2 0-5.31 4.31-9.62 9.62-9.62s9.62 4.31 9.62 9.62-4.31 9.62-9.62 9.62z"/></svg>
        WhatsApp
      </a>
    </div>
  </div>
</div>

<script>
(function(){
  const btn = document.getElementById('waBtn');
  const phone = '8801958421884';
  const text  = encodeURIComponent('Hi, I need help with my API key');

  function openWA(e){
    e.preventDefault();
    const isMobile = /Android|iPhone|iPad|iPod|Windows Phone|webOS/i.test(navigator.userAgent);
    const urls = isMobile
      ? [`whatsapp://send?phone=${phone}&text=${text}`, `https://api.whatsapp.com/send?phone=${phone}&text=${text}`]
      : [`https://web.whatsapp.com/send?phone=${phone}&text=${text}`, `https://api.whatsapp.com/send?phone=${phone}&text=${text}`];

    (function tryOpen(i){
      if(i>=urls.length){ window.open(`https://api.whatsapp.com/send?phone=${phone}&text=${text}`,'_blank','noopener'); return; }
      const w = window.open(urls[i], '_blank', 'noopener');
      if(!w) setTimeout(()=>tryOpen(i+1), 150);
    })(0);
  }
  btn.addEventListener('click', openWA);
})();
</script>
</body>
</html>
